package com.xforceplus.ultraman.app.jcmetro.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcmetro.entity.Supplier;
import com.xforceplus.ultraman.app.jcmetro.service.ISupplierService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-06-18
 */
@RestController
public class SupplierController {

  @Autowired
  private ISupplierService supplierServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param supplier ${table.comment}
   * @return
   */
  @GetMapping("/suppliers" )
  public XfR getSuppliers(XfPage page, Supplier supplier) {
    return XfR.ok(supplierServiceImpl.page(page, Wrappers.query(supplier)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/suppliers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(supplierServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param supplier ${table.comment}
   * @return XfR
   */
  @PostMapping("/suppliers")
  public XfR save(@RequestBody Supplier supplier) {
     return XfR.ok(supplierServiceImpl.save(supplier));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param supplier ${table.comment}
   * @return XfR
   */
  @PutMapping("/suppliers/{id}")
  public XfR putUpdate(@RequestBody Supplier supplier,@PathVariable Long id) {
      supplier.setId(id);
      return XfR.ok(supplierServiceImpl.updateById(supplier));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param supplier ${table.comment}
   * @return XfR
   */
  @PatchMapping("/suppliers/{id}")
  public XfR patchUpdate(@RequestBody Supplier supplier,@PathVariable Long id) {
      Supplier upsupplier = supplierServiceImpl.getById(id);
      if(upsupplier != null){
        upsupplier = ObjectCopyUtils.copyProperties(supplier,upsupplier,true);
      }
      return XfR.ok(supplierServiceImpl.updateById(upsupplier));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/suppliers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(supplierServiceImpl.removeById(id));
  }

  @PostMapping("/suppliers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "supplier");
     params.put("request", condition);

     return XfR.ok(supplierServiceImpl.querys(params));
  }

}
