package com.xforceplus.ultraman.app.jcmetro.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcmetro.entity.TempBizOrderDetail;
import com.xforceplus.ultraman.app.jcmetro.service.ITempBizOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-06-18
 */
@RestController
public class TempBizOrderDetailController {

  @Autowired
  private ITempBizOrderDetailService tempBizOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tempBizOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/tempbizorderdetails" )
  public XfR getTempBizOrderDetails(XfPage page, TempBizOrderDetail tempBizOrderDetail) {
    return XfR.ok(tempBizOrderDetailServiceImpl.page(page, Wrappers.query(tempBizOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tempbizorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tempBizOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tempBizOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/tempbizorderdetails")
  public XfR save(@RequestBody TempBizOrderDetail tempBizOrderDetail) {
     return XfR.ok(tempBizOrderDetailServiceImpl.save(tempBizOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tempBizOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/tempbizorderdetails/{id}")
  public XfR putUpdate(@RequestBody TempBizOrderDetail tempBizOrderDetail,@PathVariable Long id) {
      tempBizOrderDetail.setId(id);
      return XfR.ok(tempBizOrderDetailServiceImpl.updateById(tempBizOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tempBizOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tempbizorderdetails/{id}")
  public XfR patchUpdate(@RequestBody TempBizOrderDetail tempBizOrderDetail,@PathVariable Long id) {
      TempBizOrderDetail uptempBizOrderDetail = tempBizOrderDetailServiceImpl.getById(id);
      if(uptempBizOrderDetail != null){
        uptempBizOrderDetail = ObjectCopyUtils.copyProperties(tempBizOrderDetail,uptempBizOrderDetail,true);
      }
      return XfR.ok(tempBizOrderDetailServiceImpl.updateById(uptempBizOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tempbizorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tempBizOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/tempbizorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "temp_biz_order_detail");
     params.put("request", condition);

     return XfR.ok(tempBizOrderDetailServiceImpl.querys(params));
  }

}
