package com.xforceplus.ultraman.app.jcmksp.controller;


/**
 * 通过导入的方式创建feign客户端
 *
 * @author ultraman
 * @date 2022-09-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmksp.entity.InvSellerInvoiceItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-mksp")
public interface InvSellerInvoiceItemFeignApi {

  /**
   * 通过id查询通过导入的方式创建
   * @param  id
   * @return R
   */
  @GetMapping("/invSellerInvoiceItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增通过导入的方式创建
   * @param invSellerInvoiceItem 通过导入的方式创建
   * @return R
   */
  @PostMapping("/invSellerInvoiceItem/add")
  public R save(@RequestBody InvSellerInvoiceItem invSellerInvoiceItem);

  /**
   * 修改通过导入的方式创建
   * @param invSellerInvoiceItem 通过导入的方式创建
   * @return R
   */
  @PostMapping("/invSellerInvoiceItem/update")
  public R updateById(@RequestBody InvSellerInvoiceItem invSellerInvoiceItem);

  /**
   * 通过id删除通过导入的方式创建
   * @param  id
   * @return R
   */
  @DeleteMapping("/invSellerInvoiceItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}