package com.xforceplus.ultraman.app.jcmksp.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开票状态
 * </p>
 *
 * @author ultraman
 * @since 2022-11-30
 */
public enum KpStatus {

    _0("0", "未开票"),
    _2("2", "已开票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    KpStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KpStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
