package com.xforceplus.ultraman.app.jcmksp.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-11-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GtsFile implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * Billing单号
   */
  private String billingNumber;

  /**
   * billing日期
   */
  private String billingDate;

  /**
   * 购方编号
   */
  private String buyerNumber;

  /**
   * 购方名称
   */
  private String buyerName;

  /**
   * 购方税号
   */
  @TableField("buyer_VAT_number")
  private String buyerVatNumber;

  /**
   * 购方地址电话
   */
  private String buyerAddress;

  /**
   * 购方银行账号
   */
  private String buyerBankInfo;

  /**
   * 备注
   */
  private String notes;

  /**
   * 红字编码
   */
  private String redNotificationLetterNumber;

  /**
   * 原始发票代码
   */
  private String originalInvoiceCode;

  /**
   * 原始发票号码
   */
  private String originalInvoiceNumber;

  /**
   * Issued By
   */
  private String issuedBy;

  /**
   * Verifier
   */
  private String verifier;

  /**
   * Collector
   */
  private String collector;

  /**
   * Payee’s Bank Name and Account
   */
  private String payeesBankNameAndAccount;

  /**
   * 销方地址电话
   */
  private String sellerAddress;

  /**
   * 商品编号
   */
  private String materialNumber;

  /**
   * 商品描述
   */
  private String materialDescription;

  /**
   * 商品规格
   */
  private String matlSpec;

  /**
   * 单位
   */
  private BigDecimal unitOfMeasure;

  /**
   * 计费数量
   */
  private BigDecimal billedQuantity;

  /**
   * 总价
   */
  private BigDecimal totalAmount;

  /**
   * 税率
   */
  private BigDecimal taxRate;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 折扣总额
   */
  private BigDecimal totalOfDiscountAmount;

  /**
   * 折扣税额
   */
  private BigDecimal taxAmountOnDiscounts;

  /**
   * 税务分类号版本
   */
  private String versionOfTaxClassificationNumber;

  /**
   * 税编
   */
  private String taxClassificationNumber;

  /**
   * 是否享受优惠政策
   */
  private String preferentialTreatment;

  /**
   * 享受税收优惠政策内容
   */
  private String preferentialTreatmentDescription;

  /**
   * 零税率识别
   */
  private String zeroTaxRateIdentification;

  /**
   * 扣除金额
   */
  private BigDecimal deductionAmount;

  /**
   * billno加商品编号
   */
  private String billnoProductno;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoice_type", invoiceType);
      map.put("billing_number", billingNumber);
      map.put("billing_date", billingDate);
      map.put("buyer_number", buyerNumber);
      map.put("buyer_name", buyerName);
      map.put("buyer_VAT_number", buyerVatNumber);
      map.put("buyer_address", buyerAddress);
      map.put("buyer_bank_info", buyerBankInfo);
      map.put("notes", notes);
      map.put("red_notification_letter_number", redNotificationLetterNumber);
      map.put("original_invoice_code", originalInvoiceCode);
      map.put("original_invoice_number", originalInvoiceNumber);
      map.put("issued_by", issuedBy);
      map.put("verifier", verifier);
      map.put("collector", collector);
      map.put("payees_bank_name_and_account", payeesBankNameAndAccount);
      map.put("seller_address", sellerAddress);
      map.put("material_number", materialNumber);
      map.put("material_description", materialDescription);
      map.put("matl_spec", matlSpec);
      map.put("unit_of_measure", unitOfMeasure);
      map.put("billed_quantity", billedQuantity);
      map.put("total_amount", totalAmount);
      map.put("tax_rate", taxRate);
      map.put("tax_amount", taxAmount);
      map.put("total_of_discount_amount", totalOfDiscountAmount);
      map.put("tax_amount_on_discounts", taxAmountOnDiscounts);
      map.put("version_of_tax_classification_number", versionOfTaxClassificationNumber);
      map.put("tax_classification_number", taxClassificationNumber);
      map.put("preferential_treatment", preferentialTreatment);
      map.put("preferential_treatment_description", preferentialTreatmentDescription);
      map.put("zero_tax_rate_identification", zeroTaxRateIdentification);
      map.put("deduction_amount", deductionAmount);
      map.put("billno_productno", billnoProductno);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static GtsFile fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    GtsFile entity = new GtsFile();
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billing_number")) {
      Object obj = map.get("billing_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billing_date")) {
      Object obj = map.get("billing_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_number")) {
      Object obj = map.get("buyer_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_name")) {
      Object obj = map.get("buyer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_VAT_number")) {
      Object obj = map.get("buyer_VAT_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerVatNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_address")) {
      Object obj = map.get("buyer_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_bank_info")) {
      Object obj = map.get("buyer_bank_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("notes")) {
      Object obj = map.get("notes");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNotes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_notification_letter_number")) {
      Object obj = map.get("red_notification_letter_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("original_invoice_code")) {
      Object obj = map.get("original_invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("original_invoice_number")) {
      Object obj = map.get("original_invoice_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginalInvoiceNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issued_by")) {
      Object obj = map.get("issued_by");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIssuedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verifier")) {
      Object obj = map.get("verifier");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifier((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collector")) {
      Object obj = map.get("collector");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollector((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payees_bank_name_and_account")) {
      Object obj = map.get("payees_bank_name_and_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayeesBankNameAndAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_number")) {
      Object obj = map.get("material_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_description")) {
      Object obj = map.get("material_description");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matl_spec")) {
      Object obj = map.get("matl_spec");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatlSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit_of_measure")) {
      Object obj = map.get("unit_of_measure");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitOfMeasure((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitOfMeasure(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitOfMeasure(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitOfMeasure(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitOfMeasure(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billed_quantity")) {
      Object obj = map.get("billed_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBilledQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBilledQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBilledQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBilledQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBilledQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_of_discount_amount")) {
      Object obj = map.get("total_of_discount_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalOfDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalOfDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalOfDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalOfDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalOfDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount_on_discounts")) {
      Object obj = map.get("tax_amount_on_discounts");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmountOnDiscounts((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmountOnDiscounts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmountOnDiscounts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmountOnDiscounts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmountOnDiscounts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("version_of_tax_classification_number")) {
      Object obj = map.get("version_of_tax_classification_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVersionOfTaxClassificationNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_classification_number")) {
      Object obj = map.get("tax_classification_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxClassificationNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preferential_treatment")) {
      Object obj = map.get("preferential_treatment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreferentialTreatment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preferential_treatment_description")) {
      Object obj = map.get("preferential_treatment_description");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreferentialTreatmentDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zero_tax_rate_identification")) {
      Object obj = map.get("zero_tax_rate_identification");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZeroTaxRateIdentification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deduction_amount")) {
      Object obj = map.get("deduction_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeductionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeductionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeductionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDeductionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeductionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("billno_productno")) {
      Object obj = map.get("billno_productno");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillnoProductno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billing_number")) {
      Object obj = map.get("billing_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billing_date")) {
      Object obj = map.get("billing_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_number")) {
      Object obj = map.get("buyer_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_name")) {
      Object obj = map.get("buyer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_VAT_number")) {
      Object obj = map.get("buyer_VAT_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerVatNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_address")) {
      Object obj = map.get("buyer_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_bank_info")) {
      Object obj = map.get("buyer_bank_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("notes")) {
      Object obj = map.get("notes");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNotes((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("red_notification_letter_number")) {
      Object obj = map.get("red_notification_letter_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotificationLetterNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("original_invoice_code")) {
      Object obj = map.get("original_invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("original_invoice_number")) {
      Object obj = map.get("original_invoice_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issued_by")) {
      Object obj = map.get("issued_by");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuedBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verifier")) {
      Object obj = map.get("verifier");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifier((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collector")) {
      Object obj = map.get("collector");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollector((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payees_bank_name_and_account")) {
      Object obj = map.get("payees_bank_name_and_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayeesBankNameAndAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material_number")) {
      Object obj = map.get("material_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material_description")) {
      Object obj = map.get("material_description");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matl_spec")) {
      Object obj = map.get("matl_spec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatlSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit_of_measure")) {
      Object obj = map.get("unit_of_measure");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitOfMeasure((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitOfMeasure(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitOfMeasure(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setUnitOfMeasure(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitOfMeasure(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("billed_quantity")) {
      Object obj = map.get("billed_quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBilledQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBilledQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBilledQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setBilledQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBilledQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("total_of_discount_amount")) {
      Object obj = map.get("total_of_discount_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalOfDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalOfDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalOfDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTotalOfDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalOfDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount_on_discounts")) {
      Object obj = map.get("tax_amount_on_discounts");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmountOnDiscounts((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmountOnDiscounts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmountOnDiscounts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmountOnDiscounts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmountOnDiscounts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("version_of_tax_classification_number")) {
      Object obj = map.get("version_of_tax_classification_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionOfTaxClassificationNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_classification_number")) {
      Object obj = map.get("tax_classification_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxClassificationNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("preferential_treatment")) {
      Object obj = map.get("preferential_treatment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreferentialTreatment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("preferential_treatment_description")) {
      Object obj = map.get("preferential_treatment_description");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreferentialTreatmentDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zero_tax_rate_identification")) {
      Object obj = map.get("zero_tax_rate_identification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZeroTaxRateIdentification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deduction_amount")) {
      Object obj = map.get("deduction_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDeductionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDeductionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDeductionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDeductionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDeductionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("billno_productno")) {
      Object obj = map.get("billno_productno");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillnoProductno((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
