package com.xforceplus.ultraman.app.jcmksp.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillingMain implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * billing单号
   */
  private String billingNo;

  /**
   * 购方编号
   */
  private String purchaserNo;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * 购方地址
   */
  private String purchaserAddress;

  /**
   * 购方电话
   */
  private String purchaserTel;

  /**
   * 购方银行名称
   */
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;

  /**
   * 销方编号
   */
  private String sellerNo;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 销方地址
   */
  private String sellerAddress;

  /**
   * 销方电话
   */
  private String sellerTel;

  /**
   * 销方银行名称
   */
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  private String sellerBankAccount;

  /**
   * 业务单类型
   */
  private String salesBillType;

  /**
   * 计价方式
   */
  @TableField("priceMethod")
  private String priceMethod;

  /**
   * 备注
   */
  private String remark;

  /**
   * 匹配状态
   */
  private String matchStatus;

  /**
   * 单据状态
   */
  private String billStatus;

  /**
   * 上传反馈消息
   */
  private String uploadMsg;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 拓展字段1
   */
  private String ext1;

  /**
   * 拓展字段2
   */
  private String ext2;

  /**
   * 拓展字段3
   */
  private String ext3;

  /**
   * 拓展字段4
   */
  private String ext4;

  /**
   * 拓展字段5
   */
  private String ext5;

  /**
   * 过账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime postingDate;

  /**
   * Created On
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createdOn;

  /**
   * 明细行总数
   */
  private String detailSelectedCount;

  /**
   * po单号
   */
  private String detailPoOrder;

  /**
   * 销售订单号
   */
  private String detailSalesOrder;

  /**
   * 开票状态
   */
  private String kpStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billing_no", billingNo);
      map.put("purchaser_no", purchaserNo);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_bank_name", purchaserBankName);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("seller_no", sellerNo);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_name", sellerName);
      map.put("seller_address", sellerAddress);
      map.put("seller_tel", sellerTel);
      map.put("seller_bank_name", sellerBankName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("sales_bill_type", salesBillType);
      map.put("priceMethod", priceMethod);
      map.put("remark", remark);
      map.put("match_status", matchStatus);
      map.put("bill_status", billStatus);
      map.put("upload_msg", uploadMsg);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoice_type", invoiceType);
      map.put("amount_with_tax", amountWithTax);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("posting_date", BocpGenUtils.toTimestamp(postingDate));
      map.put("created_on", BocpGenUtils.toTimestamp(createdOn));
      map.put("detail_selected_count", detailSelectedCount);
      map.put("detail_po_order", detailPoOrder);
      map.put("detail_sales_order", detailSalesOrder);
      map.put("kp_status", kpStatus);
      return map;
  }

  public static BillingMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillingMain entity = new BillingMain();
    if(map.containsKey("billing_no")) {
      Object obj = map.get("billing_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_bill_type")) {
      Object obj = map.get("sales_bill_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_status")) {
      Object obj = map.get("bill_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upload_msg")) {
      Object obj = map.get("upload_msg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUploadMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("posting_date")) {
      Object obj = map.get("posting_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPostingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPostingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPostingDate(null);
      }
    }
    if(map.containsKey("created_on")) {
      Object obj = map.get("created_on");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreatedOn(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreatedOn((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreatedOn(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreatedOn(null);
      }
    }
    if(map.containsKey("detail_selected_count")) {
      Object obj = map.get("detail_selected_count");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetailSelectedCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detail_po_order")) {
      Object obj = map.get("detail_po_order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetailPoOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detail_sales_order")) {
      Object obj = map.get("detail_sales_order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetailSalesOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kp_status")) {
      Object obj = map.get("kp_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKpStatus((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
