package com.xforceplus.ultraman.app.jcmksp.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * inv_seller_invoice
 * </p>
 *
 * @author ultraman
 * @since 2022-09-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvSellerInvoice implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 预制发票序列号
   */
  private Long preInvoiceId;
  /**
   * 批次号
   */
  private Long batchNo;
  /**
   * 系统外批次号  默认batch_no的值
   */
  private Long outBatchNo;
  /**
   * 结算单序号
   */
  private String salesbillId;
  /**
   * 结算单号（企业）
   */
  private String salesbillNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 销方集团id
   */
  private Long sellerGroupId;
  /**
   * 销方租户id
   */
  private Long sellerTenantId;
  /**
   * 销方租户公司编号
   */
  private String sellerNo;
  /**
   * 销方组织ID
   */
  private Long sellerId;
  /**
   * 销方代码
   */
  private String sellerCode;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方纳税人识别号
   */
  private String sellerTaxNo;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方银行账号
   */
  private String sellerBankAccount;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方集团id
   */
  private Long purchaserGroupId;
  /**
   * 购方租户id
   */
  private Long purchaserTenantId;
  /**
   * 购方组织ID
   */
  private Long purchaserId;
  /**
   * 购方租户公司编号
   */
  private String purchaserNo;
  /**
   * 购方纳税人识别号
   */
  private String purchaserTaxNo;
  /**
   * 购方电话
   */
  private String purchaserTel;
  /**
   * 购方地址
   */
  private String purchaserAddress;
  /**
   * 购方银行名称
   */
  private String purchaserBankName;
  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;
  /**
   * 购方电子支付标识
   */
  private String purchaserEPayId;
  /**
   * 红蓝标识 1-蓝票 2-红票 3-红冲票
   */
  private String invoiceColor;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 机器编码
   */
  private String machineCode;
  /**
   * 开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrawDate;
  /**
   * check_code
   */
  private String checkCode;
  /**
   * 收款人姓名
   */
  private String cashierName;
  /**
   * 复核人姓名
   */
  private String checkerName;
  /**
   * 开票人姓名
   */
  private String invoicerName;
  /**
   * 备注
   */
  private String remark;
  /**
   * 电子签名
   */
  private String electronicSignature;
  /**
   * 发票来源 0-直连开票 1-辅助抽取 2-手工回填
   */
  private String invoiceOrigin;
  /**
   * 发票来源方 0-4.0平台 1-协同平台
   */
  private String invoiceFrom;
  /**
   * 系统来源 下发数据需要  由属地直接传过来
   */
  private String systemOrig;
  /**
   * 特殊发票标记  0-默认  1-通行费   2-成品油 3-区块链发票
   */
  private Long specialInvoiceFlag;
  /**
   * 单据类型
   */
  private String billType;
  /**
   * 适用业务单据类型
   */
  private String businessBillType;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 原发票号码
   */
  private String originInvoiceNo;
  /**
   * 原发票代码
   */
  private String originInvoiceCode;
  /**
   * 原蓝票的开票日期
   */
  private String originPaperDrawDate;
  /**
   * 原发票类型
   */
  private String originInvoiceType;
  /**
   * 查验状态 0-未查验(默认) 2-查验中 3-查验成功 4-查验失败 5-次日查
   */
  private Long veriStatus;
  /**
   * 密文
   */
  private String cipherText;
  /**
   * 二维密文
   */
  private String cipherTextTwoCode;
  /**
   * 虚拟标志
   */
  private String virtualFlag;
  /**
   * 红冲时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime redTime;
  /**
   * 红冲人id
   */
  private Long redUserId;
  /**
   * 红冲人姓名
   */
  private String redUserName;
  /**
   * 红字信息表编号
   */
  private String redNotificationNo;
  /**
   * 销货清单文件打印标志（0-否,1-是）默认0
   */
  private Long saleListFileFlag;
  /**
   * 打印内容标志0-打印单价和数量1-不打印单价和数量,默认0
   */
  private Long printContentFlag;
  /**
   * ofd路径
   */
  private String ofdPath;
  /**
   * pdf路径
   */
  private String pdfPath;
  /**
   * 接收方邮箱
   */
  private String receiveUserEmail;
  /**
   * 开票点名称
   */
  private String makeOutUnitName;
  /**
   * 处理状态 1-正常  2-处理中 3-业务系统红冲 4-业务系统作废 5-进项退回
   */
  private String handleStatus;
  /**
   * 处理备注
   */
  private String handleRemark;
  /**
   * 外部批次生成标志 1-不生成 0-生成
   */
  private String outCheckStatus;
  /**
   * 系统外锁定配置 0-锁红冲作废 1-锁红冲 2-锁作废
   */
  private String outLockConfig;
  /**
   * 认证状态 0-默认 1-不可认证 2-未认证 3-认证中 4-认证成功 5-认证失败 6-认证异常 7-已转出
   */
  private String identifyStatus;
  /**
   * 打印状态1-已打印 0-未打印
   */
  private String printStatus;
  /**
   * 退票状态 0-未退(默认) 1-已退
   */
  private String retreatStatus;
  /**
   * 付款状态 0-未付款(默认) 1-部分付款 2-已付款
   */
  private String paymentStatus;
  /**
   * 开票点代码
   */
  private String makeOutUnitCode;
  /**
   * 设备唯一码
   */
  private String deviceUn;
  /**
   * 终端唯一码
   */
  private String terminalUn;
  /**
   * 终端类型 1-单盘 2-服务器 4-区块链
   */
  private Long terminalType;
  /**
   * 作废的人名字
   */
  private String deposeUserName;
  /**
   * 作废时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deposeTime;
  /**
   * 作废操作账号
   */
  private Long deposeUserId;
  /**
   * 权限ID
   */
  private Long sysOrgId;
  /**
   * ext1
   */
  private String ext1;
  /**
   * ext2
   */
  private String ext2;
  /**
   * ext3
   */
  private String ext3;
  /**
   * ext4
   */
  private String ext4;
  /**
   * ext5
   */
  private String ext5;
  /**
   * ext6
   */
  private String ext6;
  /**
   * ext7
   */
  private String ext7;
  /**
   * ext8
   */
  private String ext8;
  /**
   * ext11
   */
  private String ext9;
  /**
   * ext10
   */
  private String ext10;
  /**
   * ext11
   */
  private String ext11;
  /**
   * ext12
   */
  private String ext12;
  /**
   * ext13
   */
  private String ext13;
  /**
   * ext14
   */
  private String ext14;
  /**
   * ext15
   */
  private String ext15;
  /**
   * ext16
   */
  private String ext16;
  /**
   * ext17
   */
  private String ext17;
  /**
   * ext18
   */
  private String ext18;
  /**
   * ext19
   */
  private String ext19;
  /**
   * ext20
   */
  private String ext20;
  /**
   * ext21
   */
  private String ext21;
  /**
   * ext22
   */
  private String ext22;
  /**
   * ext23
   */
  private String ext23;
  /**
   * 扩展字段24
   */
  private String ext24;
  /**
   * 扩展字段25
   */
  private String ext25;
  /**
   * 发票影像的URL
   */
  private String invoiceUrl;
  /**
   * 单据合并类型 0-未合并 1-自动组合 2-自动合并
   */
  private Long mergeType;
  /**
   * 用户ID下发数据需要,由属地直接传过来
   */
  private String customerNo;
  /**
   * 锁定状态 0-未锁定;1-页面锁定;2-作废锁;3-打印锁;4-红冲锁;
   */
  private Long lockFlag;
  /**
   * 物流 收件人
   */
  private String addressee;
  /**
   * 物流-收件人电话
   */
  private String addresseeTel;
  /**
   * 物流-收件人省份
   */
  private String addresseeProvince;
  /**
   * 物流-收件人城市
   */
  private String addresseeCity;
  /**
   * 物流-收件人所在县区
   */
  private String addresseeCounty;
  /**
   * 物流-收件人地址
   */
  private String direction;
  /**
   * 物流备注信息
   */
  private String logisticRemark;
  /**
   * 收件人所在单位
   */
  private String addresseeComp;
  /**
   * 收件人邮编
   */
  private String addresseePost;
  /**
   * 物流状态 1-待寄送 3-寄送中
   */
  private Long businessLgtStatus;
  /**
   * 审批流程id
   */
  private String procInstId;
  /**
   * 0:正常 1:红冲 2:作废
   */
  private Long auditType;
  /**
   * 开票机号
   */
  private String diskNo;
  /**
   * 系统来源类型: 0接口传入，1页面导入
   */
  private Long systemOrigType;
  /**
   * 电子数据同步时间
   */
  private Long electronicDataSyncTime;
  /**
   * 销方银行信息
   */
  private String sellerBankInfo;
  /**
   * 销方地址电话
   */
  private String sellerAddrTel;
  /**
   * 购方银行信息
   */
  private String purchaserBankInfo;
  /**
   * 购方地址电话
   */
  private String purchaserAddrTel;
  /**
   * 开具原因 
   */
  private String makingReason;
  /**
   * 开票方式 0-否 1-是
   */
  private Long makeType;
  /**
   * 接收方电话
   */
  private String receiveUserTel;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 红冲状态2
   */
  private String redStatus;
  /**
   * 发票状态
   */
  private String status;
  /**
   * 阳光城-生成凭证后锁定、解锁标志
   */
  private String matchedStatus;
  /**
   * 作废标识
   */
  private String abandonFlag;
  /**
   * 业务类型
   */
  private String busiType;
  /**
   * 成品油标识
   */
  private String oilTypeFlag;
  /**
   * 销方类型
   */
  private String sellerType;
  /**
   * 门店号
   */
  private String storeNo;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("pre_invoice_id", preInvoiceId);
      map.put("batch_no", batchNo);
      map.put("out_batch_no", outBatchNo);
      map.put("salesbill_id", salesbillId);
      map.put("salesbill_no", salesbillNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("seller_group_id", sellerGroupId);
      map.put("seller_tenant_id", sellerTenantId);
      map.put("seller_no", sellerNo);
      map.put("seller_id", sellerId);
      map.put("seller_code", sellerCode);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_tel", sellerTel);
      map.put("seller_address", sellerAddress);
      map.put("seller_bank_name", sellerBankName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_group_id", purchaserGroupId);
      map.put("purchaser_tenant_id", purchaserTenantId);
      map.put("purchaser_id", purchaserId);
      map.put("purchaser_no", purchaserNo);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_bank_name", purchaserBankName);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("purchaser_e_pay_id", purchaserEPayId);
      map.put("invoice_color", invoiceColor);
      map.put("invoice_type", invoiceType);
      map.put("machine_code", machineCode);
      map.put("paper_draw_date", BocpGenUtils.toTimestamp(paperDrawDate));
      map.put("check_code", checkCode);
      map.put("cashier_name", cashierName);
      map.put("checker_name", checkerName);
      map.put("invoicer_name", invoicerName);
      map.put("remark", remark);
      map.put("electronic_signature", electronicSignature);
      map.put("invoice_origin", invoiceOrigin);
      map.put("invoice_from", invoiceFrom);
      map.put("system_orig", systemOrig);
      map.put("special_invoice_flag", specialInvoiceFlag);
      map.put("bill_type", billType);
      map.put("business_bill_type", businessBillType);
      map.put("amount_with_tax", amountWithTax);
      map.put("tax_rate", taxRate);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("origin_invoice_no", originInvoiceNo);
      map.put("origin_invoice_code", originInvoiceCode);
      map.put("origin_paper_draw_date", originPaperDrawDate);
      map.put("origin_invoice_type", originInvoiceType);
      map.put("veri_status", veriStatus);
      map.put("cipher_text", cipherText);
      map.put("cipher_text_two_code", cipherTextTwoCode);
      map.put("virtual_flag", virtualFlag);
      map.put("red_time", BocpGenUtils.toTimestamp(redTime));
      map.put("red_user_id", redUserId);
      map.put("red_user_name", redUserName);
      map.put("red_notification_no", redNotificationNo);
      map.put("sale_list_file_flag", saleListFileFlag);
      map.put("print_content_flag", printContentFlag);
      map.put("ofd_path", ofdPath);
      map.put("pdf_path", pdfPath);
      map.put("receive_user_email", receiveUserEmail);
      map.put("make_out_unit_name", makeOutUnitName);
      map.put("handle_status", handleStatus);
      map.put("handle_remark", handleRemark);
      map.put("out_check_status", outCheckStatus);
      map.put("out_lock_config", outLockConfig);
      map.put("identify_status", identifyStatus);
      map.put("print_status", printStatus);
      map.put("retreat_status", retreatStatus);
      map.put("payment_status", paymentStatus);
      map.put("make_out_unit_code", makeOutUnitCode);
      map.put("device_un", deviceUn);
      map.put("terminal_un", terminalUn);
      map.put("terminal_type", terminalType);
      map.put("depose_user_name", deposeUserName);
      map.put("depose_time", BocpGenUtils.toTimestamp(deposeTime));
      map.put("depose_user_id", deposeUserId);
      map.put("sys_org_id", sysOrgId);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("invoice_url", invoiceUrl);
      map.put("merge_type", mergeType);
      map.put("customer_no", customerNo);
      map.put("lock_flag", lockFlag);
      map.put("addressee", addressee);
      map.put("addressee_tel", addresseeTel);
      map.put("addressee_province", addresseeProvince);
      map.put("addressee_city", addresseeCity);
      map.put("addressee_county", addresseeCounty);
      map.put("direction", direction);
      map.put("logistic_remark", logisticRemark);
      map.put("addressee_comp", addresseeComp);
      map.put("addressee_post", addresseePost);
      map.put("business_lgt_status", businessLgtStatus);
      map.put("proc_inst_id", procInstId);
      map.put("audit_type", auditType);
      map.put("disk_no", diskNo);
      map.put("system_orig_type", systemOrigType);
      map.put("electronic_data_sync_time", electronicDataSyncTime);
      map.put("seller_bank_info", sellerBankInfo);
      map.put("seller_addr_tel", sellerAddrTel);
      map.put("purchaser_bank_info", purchaserBankInfo);
      map.put("purchaser_addr_tel", purchaserAddrTel);
      map.put("making_reason", makingReason);
      map.put("make_type", makeType);
      map.put("receive_user_tel", receiveUserTel);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("red_status", redStatus);
      map.put("status", status);
      map.put("matched_status", matchedStatus);
      map.put("abandon_flag", abandonFlag);
      map.put("busiType", busiType);
      map.put("oilTypeFlag", oilTypeFlag);
      map.put("sellerType", sellerType);
      map.put("storeNo", storeNo);

      return map;
  }

  public static InvSellerInvoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvSellerInvoice entity = new InvSellerInvoice();

    if(map.containsKey("pre_invoice_id")) {
      Object obj = map.get("pre_invoice_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPreInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPreInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPreInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("out_batch_no")) {
      Object obj = map.get("out_batch_no");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOutBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("salesbill_id")) {
      Object obj = map.get("salesbill_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbill_no")) {
      Object obj = map.get("salesbill_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_group_id")) {
      Object obj = map.get("seller_group_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_group_id")) {
      Object obj = map.get("purchaser_group_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_id")) {
      Object obj = map.get("purchaser_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_e_pay_id")) {
      Object obj = map.get("purchaser_e_pay_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserEPayId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_color")) {
      Object obj = map.get("invoice_color");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_draw_date")) {
      Object obj = map.get("paper_draw_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronic_signature")) {
      Object obj = map.get("electronic_signature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElectronicSignature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_origin")) {
      Object obj = map.get("invoice_origin");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_from")) {
      Object obj = map.get("invoice_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSpecialInvoiceFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSpecialInvoiceFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSpecialInvoiceFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bill_type")) {
      Object obj = map.get("bill_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_bill_type")) {
      Object obj = map.get("business_bill_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_paper_draw_date")) {
      Object obj = map.get("origin_paper_draw_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_type")) {
      Object obj = map.get("origin_invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veri_status")) {
      Object obj = map.get("veri_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVeriStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher_text_two_code")) {
      Object obj = map.get("cipher_text_two_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherTextTwoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtual_flag")) {
      Object obj = map.get("virtual_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVirtualFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_time")) {
      Object obj = map.get("red_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRedTime(null);
      }
    }
    if(map.containsKey("red_user_id")) {
      Object obj = map.get("red_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRedUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("red_user_name")) {
      Object obj = map.get("red_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_notification_no")) {
      Object obj = map.get("red_notification_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sale_list_file_flag")) {
      Object obj = map.get("sale_list_file_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("print_content_flag")) {
      Object obj = map.get("print_content_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPrintContentFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrintContentFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPrintContentFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ofd_path")) {
      Object obj = map.get("ofd_path");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfdPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdf_path")) {
      Object obj = map.get("pdf_path");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_user_email")) {
      Object obj = map.get("receive_user_email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("make_out_unit_name")) {
      Object obj = map.get("make_out_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakeOutUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handle_status")) {
      Object obj = map.get("handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handle_remark")) {
      Object obj = map.get("handle_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("out_check_status")) {
      Object obj = map.get("out_check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOutCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("out_lock_config")) {
      Object obj = map.get("out_lock_config");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOutLockConfig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("identify_status")) {
      Object obj = map.get("identify_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIdentifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("print_status")) {
      Object obj = map.get("print_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrintStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("make_out_unit_code")) {
      Object obj = map.get("make_out_unit_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakeOutUnitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("device_un")) {
      Object obj = map.get("device_un");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("terminal_un")) {
      Object obj = map.get("terminal_un");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTerminalUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("terminal_type")) {
      Object obj = map.get("terminal_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTerminalType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTerminalType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTerminalType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("depose_user_name")) {
      Object obj = map.get("depose_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeposeUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("depose_time")) {
      Object obj = map.get("depose_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeposeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeposeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeposeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeposeTime(null);
      }
    }
    if(map.containsKey("depose_user_id")) {
      Object obj = map.get("depose_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeposeUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeposeUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDeposeUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sys_org_id")) {
      Object obj = map.get("sys_org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSysOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_url")) {
      Object obj = map.get("invoice_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merge_type")) {
      Object obj = map.get("merge_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMergeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMergeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lock_flag")) {
      Object obj = map.get("lock_flag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLockFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_tel")) {
      Object obj = map.get("addressee_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_province")) {
      Object obj = map.get("addressee_province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_city")) {
      Object obj = map.get("addressee_city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_county")) {
      Object obj = map.get("addressee_county");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_remark")) {
      Object obj = map.get("logistic_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_comp")) {
      Object obj = map.get("addressee_comp");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeComp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addressee_post")) {
      Object obj = map.get("addressee_post");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseePost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_lgt_status")) {
      Object obj = map.get("business_lgt_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessLgtStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessLgtStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBusinessLgtStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("proc_inst_id")) {
      Object obj = map.get("proc_inst_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcInstId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_type")) {
      Object obj = map.get("audit_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAuditType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("disk_no")) {
      Object obj = map.get("disk_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiskNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig_type")) {
      Object obj = map.get("system_orig_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSystemOrigType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("electronic_data_sync_time")) {
      Object obj = map.get("electronic_data_sync_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElectronicDataSyncTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setElectronicDataSyncTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setElectronicDataSyncTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_info")) {
      Object obj = map.get("seller_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_info")) {
      Object obj = map.get("purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("making_reason")) {
      Object obj = map.get("making_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("make_type")) {
      Object obj = map.get("make_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMakeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMakeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receive_user_tel")) {
      Object obj = map.get("receive_user_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_status")) {
      Object obj = map.get("red_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matched_status")) {
      Object obj = map.get("matched_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abandon_flag")) {
      Object obj = map.get("abandon_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbandonFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("busiType")) {
      Object obj = map.get("busiType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusiType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oilTypeFlag")) {
      Object obj = map.get("oilTypeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOilTypeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreNo((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("pre_invoice_id")) {
      Object obj = map.get("pre_invoice_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPreInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPreInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPreInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("out_batch_no")) {
      Object obj = map.get("out_batch_no");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOutBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOutBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOutBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("salesbill_id")) {
      Object obj = map.get("salesbill_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesbillId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("salesbill_no")) {
      Object obj = map.get("salesbill_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesbillNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_group_id")) {
      Object obj = map.get("seller_group_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_group_id")) {
      Object obj = map.get("purchaser_group_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_id")) {
      Object obj = map.get("purchaser_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddress((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_e_pay_id")) {
      Object obj = map.get("purchaser_e_pay_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserEPayId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_color")) {
      Object obj = map.get("invoice_color");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceColor((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMachineCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paper_draw_date")) {
      Object obj = map.get("paper_draw_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaperDrawDate(null);
      }
   }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCashierName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoicerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("electronic_signature")) {
      Object obj = map.get("electronic_signature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setElectronicSignature((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_origin")) {
      Object obj = map.get("invoice_origin");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceOrigin((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_from")) {
      Object obj = map.get("invoice_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceFrom((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSystemOrig((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSpecialInvoiceFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSpecialInvoiceFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSpecialInvoiceFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("bill_type")) {
      Object obj = map.get("bill_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("business_bill_type")) {
      Object obj = map.get("business_bill_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessBillType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("origin_paper_draw_date")) {
      Object obj = map.get("origin_paper_draw_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginPaperDrawDate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("origin_invoice_type")) {
      Object obj = map.get("origin_invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("veri_status")) {
      Object obj = map.get("veri_status");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setVeriStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setVeriStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setVeriStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherText((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cipher_text_two_code")) {
      Object obj = map.get("cipher_text_two_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherTextTwoCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("virtual_flag")) {
      Object obj = map.get("virtual_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVirtualFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("red_time")) {
      Object obj = map.get("red_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRedTime(null);
      }
   }
    if(map.containsKey("red_user_id")) {
      Object obj = map.get("red_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRedUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRedUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("red_user_name")) {
      Object obj = map.get("red_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("red_notification_no")) {
      Object obj = map.get("red_notification_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedNotificationNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sale_list_file_flag")) {
      Object obj = map.get("sale_list_file_flag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSaleListFileFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSaleListFileFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSaleListFileFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("print_content_flag")) {
      Object obj = map.get("print_content_flag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPrintContentFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPrintContentFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPrintContentFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("ofd_path")) {
      Object obj = map.get("ofd_path");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOfdPath((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pdf_path")) {
      Object obj = map.get("pdf_path");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPdfPath((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receive_user_email")) {
      Object obj = map.get("receive_user_email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveUserEmail((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("make_out_unit_name")) {
      Object obj = map.get("make_out_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMakeOutUnitName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("handle_status")) {
      Object obj = map.get("handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setHandleStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("handle_remark")) {
      Object obj = map.get("handle_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setHandleRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("out_check_status")) {
      Object obj = map.get("out_check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOutCheckStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("out_lock_config")) {
      Object obj = map.get("out_lock_config");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOutLockConfig((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("identify_status")) {
      Object obj = map.get("identify_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIdentifyStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("print_status")) {
      Object obj = map.get("print_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPrintStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRetreatStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("make_out_unit_code")) {
      Object obj = map.get("make_out_unit_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMakeOutUnitCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("device_un")) {
      Object obj = map.get("device_un");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceUn((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("terminal_un")) {
      Object obj = map.get("terminal_un");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTerminalUn((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("terminal_type")) {
      Object obj = map.get("terminal_type");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTerminalType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTerminalType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTerminalType(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("depose_user_name")) {
      Object obj = map.get("depose_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeposeUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("depose_time")) {
      Object obj = map.get("depose_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeposeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeposeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeposeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeposeTime(null);
      }
   }
    if(map.containsKey("depose_user_id")) {
      Object obj = map.get("depose_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeposeUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeposeUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setDeposeUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("sys_org_id")) {
      Object obj = map.get("sys_org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSysOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSysOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSysOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt3((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt4((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt5((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt6((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt7((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt8((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt9((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt10((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt11((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt12((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt13((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt14((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt15((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt16((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt17((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt18((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt19((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt20((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt21((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt22((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt23((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt24((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt25((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_url")) {
      Object obj = map.get("invoice_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceUrl((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("merge_type")) {
      Object obj = map.get("merge_type");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMergeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMergeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMergeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lock_flag")) {
      Object obj = map.get("lock_flag");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLockFlag((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLockFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setLockFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddressee((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("addressee_tel")) {
      Object obj = map.get("addressee_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("addressee_province")) {
      Object obj = map.get("addressee_province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeProvince((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("addressee_city")) {
      Object obj = map.get("addressee_city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeCity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("addressee_county")) {
      Object obj = map.get("addressee_county");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeCounty((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDirection((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("logistic_remark")) {
      Object obj = map.get("logistic_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("addressee_comp")) {
      Object obj = map.get("addressee_comp");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseeComp((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("addressee_post")) {
      Object obj = map.get("addressee_post");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAddresseePost((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("business_lgt_status")) {
      Object obj = map.get("business_lgt_status");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBusinessLgtStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBusinessLgtStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBusinessLgtStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("proc_inst_id")) {
      Object obj = map.get("proc_inst_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProcInstId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_type")) {
      Object obj = map.get("audit_type");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuditType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuditType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAuditType(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("disk_no")) {
      Object obj = map.get("disk_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiskNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("system_orig_type")) {
      Object obj = map.get("system_orig_type");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSystemOrigType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSystemOrigType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSystemOrigType(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("electronic_data_sync_time")) {
      Object obj = map.get("electronic_data_sync_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setElectronicDataSyncTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setElectronicDataSyncTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setElectronicDataSyncTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("seller_bank_info")) {
      Object obj = map.get("seller_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankInfo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddrTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_bank_info")) {
      Object obj = map.get("purchaser_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("making_reason")) {
      Object obj = map.get("making_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMakingReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("make_type")) {
      Object obj = map.get("make_type");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMakeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMakeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMakeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("receive_user_tel")) {
      Object obj = map.get("receive_user_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveUserTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("red_status")) {
      Object obj = map.get("red_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("matched_status")) {
      Object obj = map.get("matched_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMatchedStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("abandon_flag")) {
      Object obj = map.get("abandon_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAbandonFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("busiType")) {
      Object obj = map.get("busiType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusiType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("oilTypeFlag")) {
      Object obj = map.get("oilTypeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOilTypeFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreNo((String)obj);
        }
      } else{
      }
   }

  }

}
