package com.xforceplus.ultraman.app.jcmksp.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2022-08-04
 */
public enum InvType {

    S("s", " s-增值税专用发票"),
    C("c", " c-增值税普通发票"),
    CE("ce", " ce-增值税电子普通发票"),
    JU("ju", " ju-增值税普通发票（卷票）"),
    CT("ct", " ct-通行费增值税电子普通发票"),
    V("v", " v-机动车统一销售发票"),
    SE("se", " se-增值税电子专用发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ju":
                return JU;
            case "ct":
                return CT;
            case "v":
                return V;
            case "se":
                return SE;
            default:
                return null;
        }
    }
}
