package com.xforceplus.ultraman.app.jcmksp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmksp.entity.InvoiceRelation;
import com.xforceplus.ultraman.app.jcmksp.service.IInvoiceRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-22
 */
@RestController
public class InvoiceRelationController {

  @Autowired
  private IInvoiceRelationService invoiceRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRelation ${table.comment}
   * @return
   */
  @GetMapping("/invoicerelations" )
  public XfR getInvoiceRelations(XfPage page, InvoiceRelation invoiceRelation) {
    return XfR.ok(invoiceRelationServiceImpl.page(page, Wrappers.query(invoiceRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicerelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicerelations")
  public XfR save(@RequestBody InvoiceRelation invoiceRelation) {
     return XfR.ok(invoiceRelationServiceImpl.save(invoiceRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicerelations/{id}")
  public XfR putUpdate(@RequestBody InvoiceRelation invoiceRelation,@PathVariable Long id) {
      invoiceRelation.setId(id);
      return XfR.ok(invoiceRelationServiceImpl.updateById(invoiceRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicerelations/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRelation invoiceRelation,@PathVariable Long id) {
      InvoiceRelation upinvoiceRelation = invoiceRelationServiceImpl.getById(id);
      if(upinvoiceRelation != null){
        upinvoiceRelation = ObjectCopyUtils.copyProperties(invoiceRelation,upinvoiceRelation,true);
      }
      return XfR.ok(invoiceRelationServiceImpl.updateById(upinvoiceRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicerelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRelationServiceImpl.removeById(id));
  }

  @PostMapping("/invoicerelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_relation");
     params.put("request", condition);

     return XfR.ok(invoiceRelationServiceImpl.querys(params));
  }

}
