package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * apply_invalid_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum ApplyInvalidFlag {

    _0("0", "正常"),
    _1("1", "申请作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyInvalidFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyInvalidFlag fromCode(String code) {
        return Stream.of(ApplyInvalidFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
