package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * audit_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum AuditStatus {

    _5("5", "取消审批申请"),
    _6("6", "请求sap锁单"),
    _7("7", "标识单据为业务单模式(不会被协同线同步逻辑给刷掉)"),
    _1("1", "未审核"),
    _2("2", "审核中"),
    _3("3", "审核通过"),
    _4("4", "审核不通过");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuditStatus fromCode(String code) {
        return Stream.of(AuditStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
