package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum BillStatus {

    _0("0", "作废"),
    _1("1", "正常"),
    _9("9", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillStatus fromCode(String code) {
        return Stream.of(BillStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
