package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * makeout_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum MakeoutStatus {

    _0("0", "未开票 "),
    _2("2", "已开票 "),
    _3("3", "已生成预制发票"),
    _4("4", "部分未提交+部分已生成预制发票 "),
    _5("5", "部分未提交+部分已开票"),
    _6("6", "部分已生成预制发票+部分已开票"),
    _7("7", "部分未提交+部分已生成预制发票+部分已开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MakeoutStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MakeoutStatus fromCode(String code) {
        return Stream.of(MakeoutStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
