package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * purchaser_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum PurchaserType {

    _1("1", "企业"),
    _2("2", "个人");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PurchaserType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurchaserType fromCode(String code) {
        return Stream.of(PurchaserType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
