package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * seal_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum SealType {

    COMPANY_SEAL("companySeal", "公章"),
    FINANCE_SEAL("financeSeal", "财务章");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SealType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SealType fromCode(String code) {
        return Stream.of(SealType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
