package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * system_orig_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum SystemOrigType {

    _0("0", "接口传入"),
    _1("1", "页面导入");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SystemOrigType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SystemOrigType fromCode(String code) {
        return Stream.of(SystemOrigType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
