package com.xforceplus.ultraman.app.jcnestle.metadata.validator;

import com.xforceplus.ultraman.app.jcnestle.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcnestle.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = null != ReadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = null != CreateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = null != MessageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = null != EnableStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = null != VariableType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = null != WorkflowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionType.class)) {
            isValid = null != ExceptionType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExceptionType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsQualified.class)) {
            isValid = null != IsQualified.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsQualified.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = null != CooperateFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessBillType.class)) {
            isValid = null != BusinessBillType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessBillType.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemTypeCode.class)) {
            isValid = null != ItemTypeCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ItemTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceType.class)) {
            isValid = null != BillInvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = null != TaxPre.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemStatus.class)) {
            isValid = null != ItemStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ItemStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialItemType.class)) {
            isValid = null != SpecialItemType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialItemType.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemOrigin.class)) {
            isValid = null != ItemOrigin.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ItemOrigin.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = null != PriceMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptType.class)) {
            isValid = null != ReceiptType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiptType.class.getSimpleName());
            }
        }
        if(clazz.equals(UsingStatus.class)) {
            isValid = null != UsingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UsingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateModifyStatus.class)) {
            isValid = null != CooperateModifyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateModifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = null != BillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MakeoutStatus.class)) {
            isValid = null != MakeoutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MakeoutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadConfirmFlag.class)) {
            isValid = null != UploadConfirmFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UploadConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveConfirmFlag.class)) {
            isValid = null != ReceiveConfirmFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiveConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaserType.class)) {
            isValid = null != PurchaserType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PurchaserType.class.getSimpleName());
            }
        }
        if(clazz.equals(MakingReason.class)) {
            isValid = null != MakingReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MakingReason.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyInvalidFlag.class)) {
            isValid = null != ApplyInvalidFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyInvalidFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigType.class)) {
            isValid = null != SystemOrigType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SystemOrigType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillAuthStatus.class)) {
            isValid = null != BillAuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillAuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = null != IsNeedAuth.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(BillRecogStatus.class)) {
            isValid = null != BillRecogStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillRecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderHistoryStatus.class)) {
            isValid = null != BizOrderHistoryStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderHistoryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoCheckStatus.class)) {
            isValid = null != AutoCheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AutoCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceType1695715096593.class)) {
            isValid = null != BillInvoiceType1695715096593.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillInvoiceType1695715096593.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = null != BusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(AttachmentType.class)) {
            isValid = null != AttachmentType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AttachmentType.class.getSimpleName());
            }
        }
        if(clazz.equals(StampedStatus.class)) {
            isValid = null != StampedStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StampedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatus.class)) {
            isValid = null != HandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SealType.class)) {
            isValid = null != SealType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SealType.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyStatus.class)) {
            isValid = null != ApplyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyReason.class)) {
            isValid = null != ApplyReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyReason.class.getSimpleName());
            }
        }
        if(clazz.equals(UsingStatus.class)) {
            isValid = null != UsingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UsingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DetailCategory.class)) {
            isValid = null != DetailCategory.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DetailCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(AttachmentGenerationStatus.class)) {
            isValid = null != AttachmentGenerationStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AttachmentGenerationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EmailStatus.class)) {
            isValid = null != EmailStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EmailStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptStatus.class)) {
            isValid = null != ReceiptStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiptStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EmailTemplate.class)) {
            isValid = null != EmailTemplate.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EmailTemplate.class.getSimpleName());
            }
        }
        if(clazz.equals(RedLetterStatus.class)) {
            isValid = null != RedLetterStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedLetterStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
