/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.app.jcnestle.metadata.validator;

import com.xforceplus.ultraman.app.jcnestle.metadata.validator.annotation.CheckUltramanPhone;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class UltramanPhoneConstraintValidator
implements ConstraintValidator<CheckUltramanPhone, String> {
    private final String MSG_FORMAT = "value must be phone number";
    private final String TYPE_PHONE = "1";
    private final String TYPE_OTHER = "2";
    String type;

    public void initialize(CheckUltramanPhone constraintAnnotation) {
        this.type = constraintAnnotation.type();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (null == value || value.length() == 0) {
            return true;
        }
        if (!"1".equals(this.type)) {
            return true;
        }
        boolean isValid = Pattern.matches("^[1-9]\\d{10}$", value);
        if (!isValid) {
            this.unValidMsg(context);
        }
        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(String.format("value must be phone number", new Object[0])).addConstraintViolation();
    }
}

