package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * apply_reason
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum ApplyReason {

    MAKING_ERROR("making_error", "开票有误"),
    TAXABLE_SERVICE_END("taxable_service_end", "应税服务中止"),
    SALES_ALLOWANCE("sales_allowance", "销售折让"),
    SALES_RETURN("sales_return", "销售退回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyReason fromCode(String code) {
        return Stream.of(ApplyReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
