package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * attachment_generation_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum AttachmentGenerationStatus {

    _0("0", "待生成"),
    _1("1", "部分生成"),
    _2("2", "全部生成"),
    __1("-1", "生成失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AttachmentGenerationStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AttachmentGenerationStatus fromCode(String code) {
        return Stream.of(AttachmentGenerationStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
