package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * attachment_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum AttachmentType {

    DEPOSIT_RECEIPT("depositReceipt", "押金收据"),
    RETURN_AGREEMENT("returnAgreement", "退货协议"),
    DISCOUNT_AGREEMENT("discountAgreement", "折让协议"),
    RETURN_AGREEMENT_CONFIRMATION("returnAgreementConfirmation", "退货协议确认书");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AttachmentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AttachmentType fromCode(String code) {
        return Stream.of(AttachmentType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
