package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_recog_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum BillRecogStatus {

    _0("0", "未识别"),
    _1("1", "部分识别"),
    _2("2", "已识别");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillRecogStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillRecogStatus fromCode(String code) {
        return Stream.of(BillRecogStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
