package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum BusinessType {

    BILLING("billing", "billing单据"),
    REDLETTER("redletter", "红字信息"),
    RECEIPT("receipt", "收据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessType fromCode(String code) {
        return Stream.of(BusinessType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
