package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * detail_category
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum DetailCategory {

    SI("SI", "销项"),
    RI("RI", "退项"),
    PA("PA", "正调整单"),
    MA("MA", "负调整单"),
    PG("PG", "赠品");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DetailCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DetailCategory fromCode(String code) {
        return Stream.of(DetailCategory.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
