package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * email_template
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum EmailTemplate {

    MT445243507437("MT445243507437", "退货邮件模版"),
    MT445243733818("MT445243733818", "折让邮件模版"),
    MT445243946323("MT445243946323", "收据发送邮件");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EmailTemplate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EmailTemplate fromCode(String code) {
        return Stream.of(EmailTemplate.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
