package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * exception_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum ExceptionType {

    _0("0", "无"),
    _1("1", "发票未盖章"),
    _2("2", "发票污损"),
    _3("3", "发票打印错位"),
    _4("4", "发票无业务单"),
    _5("5", "其他"),
    _6("6", "稽核比对不一致"),
    _7("7", "收单标记风险");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExceptionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExceptionType fromCode(String code) {
        return Stream.of(ExceptionType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
