package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_qualified
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum IsQualified {

    _0("0", "未签收"),
    _1("1", "合格"),
    _2("2", "不合格");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsQualified(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsQualified fromCode(String code) {
        return Stream.of(IsQualified.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
