package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * item_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum ItemStatus {

    _0("0", "已作废"),
    _1("1", "正常，未开具"),
    _2("2", "开票已提交"),
    _3("3", "已开票"),
    _4("4", "已退回"),
    _9("9", "已删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ItemStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ItemStatus fromCode(String code) {
        return Stream.of(ItemStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
