package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * receipt_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum ReceiptStatus {

    _0("0", "未生成"),
    _1("1", "生成待盖章"),
    _2("2", "生成已盖章"),
    _3("3", "已发邮件");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceiptStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceiptStatus fromCode(String code) {
        return Stream.of(ReceiptStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
