package com.xforceplus.ultraman.app.jcnestle.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * stamped_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public enum StampedStatus {

    PENDING("pending", "待盖章"),
    IN_PROGRESS("inProgress", "盖章中"),
    COMPLETED("completed", "已盖章");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StampedStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StampedStatus fromCode(String code) {
        return Stream.of(StampedStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
