package com.xforceplus.ultraman.app.jcnestle.metadata.validator;

import com.xforceplus.ultraman.app.jcnestle.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jcnestle.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-12-16
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreationMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MessageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnableStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VariableType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WorkflowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExceptionType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExceptionType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsQualified.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsQualified.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsQualified.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CooperateFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessBillType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessBillType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessBillType.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemTypeCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ItemTypeCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ItemTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillInvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxPre.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ZeroTax.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ItemStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ItemStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialItemType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialItemType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialItemType.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemOrigin.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ItemOrigin.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ItemOrigin.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PriceMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiptType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiptType.class.getSimpleName());
            }
        }
        if(clazz.equals(UsingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UsingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UsingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateModifyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CooperateModifyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CooperateModifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MakeoutStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MakeoutStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MakeoutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadConfirmFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UploadConfirmFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UploadConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveConfirmFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiveConfirmFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiveConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaserType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PurchaserType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PurchaserType.class.getSimpleName());
            }
        }
        if(clazz.equals(MakingReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MakingReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MakingReason.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyInvalidFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyInvalidFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyInvalidFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SystemOrigType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SystemOrigType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillAuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillAuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillAuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsNeedAuth.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(BillRecogStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillRecogStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillRecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderHistoryStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BizOrderHistoryStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BizOrderHistoryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoCheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AutoCheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AutoCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceType1695715096593.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillInvoiceType1695715096593.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillInvoiceType1695715096593.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(AttachmentType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AttachmentType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AttachmentType.class.getSimpleName());
            }
        }
        if(clazz.equals(StampedStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StampedStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StampedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SealType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SealType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SealType.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyReason.class.getSimpleName());
            }
        }
        if(clazz.equals(UsingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UsingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UsingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DetailCategory.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DetailCategory.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DetailCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(AttachmentGenerationStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AttachmentGenerationStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AttachmentGenerationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EmailStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EmailStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EmailStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiptStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiptStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EmailTemplate.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EmailTemplate.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EmailTemplate.class.getSimpleName());
            }
        }
        if(clazz.equals(RedLetterStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedLetterStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedLetterStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
