package com.xforceplus.ultraman.app.jcnestle.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcnestle.entity.BizOrderDetail;
import com.xforceplus.ultraman.app.jcnestle.service.IBizOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-13
 */
@RestController
public class BizOrderDetailController {

  @Autowired
  private IBizOrderDetailService bizOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/bizorderdetails" )
  public XfR getBizOrderDetails(XfPage page, BizOrderDetail bizOrderDetail) {
    return XfR.ok(bizOrderDetailServiceImpl.page(page, Wrappers.query(bizOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizorderdetails")
  public XfR save(@RequestBody BizOrderDetail bizOrderDetail) {
     return XfR.ok(bizOrderDetailServiceImpl.save(bizOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizorderdetails/{id}")
  public XfR putUpdate(@RequestBody BizOrderDetail bizOrderDetail,@PathVariable Long id) {
      bizOrderDetail.setId(id);
      return XfR.ok(bizOrderDetailServiceImpl.updateById(bizOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizorderdetails/{id}")
  public XfR patchUpdate(@RequestBody BizOrderDetail bizOrderDetail,@PathVariable Long id) {
      BizOrderDetail upbizOrderDetail = bizOrderDetailServiceImpl.getById(id);
      if(upbizOrderDetail != null){
        upbizOrderDetail = ObjectCopyUtils.copyProperties(bizOrderDetail,upbizOrderDetail,true);
      }
      return XfR.ok(bizOrderDetailServiceImpl.updateById(upbizOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_detail");
     params.put("request", condition);

     return XfR.ok(bizOrderDetailServiceImpl.querys(params));
  }

}
