package com.xforceplus.ultraman.app.jcnestle.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcnestle.entity.RedConfirmation;
import com.xforceplus.ultraman.app.jcnestle.service.IRedConfirmationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-13
 */
@RestController
public class RedConfirmationController {

  @Autowired
  private IRedConfirmationService redConfirmationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redConfirmation ${table.comment}
   * @return
   */
  @GetMapping("/redconfirmations" )
  public XfR getRedConfirmations(XfPage page, RedConfirmation redConfirmation) {
    return XfR.ok(redConfirmationServiceImpl.page(page, Wrappers.query(redConfirmation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redconfirmations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redConfirmationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redConfirmation ${table.comment}
   * @return XfR
   */
  @PostMapping("/redconfirmations")
  public XfR save(@RequestBody RedConfirmation redConfirmation) {
     return XfR.ok(redConfirmationServiceImpl.save(redConfirmation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redConfirmation ${table.comment}
   * @return XfR
   */
  @PutMapping("/redconfirmations/{id}")
  public XfR putUpdate(@RequestBody RedConfirmation redConfirmation,@PathVariable Long id) {
      redConfirmation.setId(id);
      return XfR.ok(redConfirmationServiceImpl.updateById(redConfirmation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redConfirmation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redconfirmations/{id}")
  public XfR patchUpdate(@RequestBody RedConfirmation redConfirmation,@PathVariable Long id) {
      RedConfirmation upredConfirmation = redConfirmationServiceImpl.getById(id);
      if(upredConfirmation != null){
        upredConfirmation = ObjectCopyUtils.copyProperties(redConfirmation,upredConfirmation,true);
      }
      return XfR.ok(redConfirmationServiceImpl.updateById(upredConfirmation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redconfirmations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redConfirmationServiceImpl.removeById(id));
  }

  @PostMapping("/redconfirmations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_confirmation");
     params.put("request", condition);

     return XfR.ok(redConfirmationServiceImpl.querys(params));
  }

}
