package com.xforceplus.ultraman.app.jcnestle.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcnestle.entity.SystemExtendDictItem;
import com.xforceplus.ultraman.app.jcnestle.service.ISystemExtendDictItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统枚举扩展明细前端控制器
 *
 * @author ultraman
 * @date 2024-12-13
 */
@RestController
public class SystemExtendDictItemController {

  @Autowired
  private ISystemExtendDictItemService systemExtendDictItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemExtendDictItem 系统枚举扩展明细
   * @return
   */
  @GetMapping("/systemextenddictitems" )
  public XfR getSystemExtendDictItems(XfPage page, SystemExtendDictItem systemExtendDictItem) {
    return XfR.ok(systemExtendDictItemServiceImpl.page(page, Wrappers.query(systemExtendDictItem)));
  }

  /**
   * 通过id查询系统枚举扩展明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemextenddictitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemExtendDictItemServiceImpl.getById(id));
  }

  /**
   * 新增系统枚举扩展明细
   * @param systemExtendDictItem 系统枚举扩展明细
   * @return XfR
   */
  @PostMapping("/systemextenddictitems")
  public XfR save(@RequestBody SystemExtendDictItem systemExtendDictItem) {
     return XfR.ok(systemExtendDictItemServiceImpl.save(systemExtendDictItem));
  }

  /**
   * 修改-传入修改后的全部数据系统枚举扩展明细
   * @param systemExtendDictItem 系统枚举扩展明细
   * @return XfR
   */
  @PutMapping("/systemextenddictitems/{id}")
  public XfR putUpdate(@RequestBody SystemExtendDictItem systemExtendDictItem,@PathVariable Long id) {
      systemExtendDictItem.setId(id);
      return XfR.ok(systemExtendDictItemServiceImpl.updateById(systemExtendDictItem));
  }

  /**
   * 修改-传入修改的数据系统枚举扩展明细
   * @param systemExtendDictItem 系统枚举扩展明细
   * @return XfR
   */
  @PatchMapping("/systemextenddictitems/{id}")
  public XfR patchUpdate(@RequestBody SystemExtendDictItem systemExtendDictItem,@PathVariable Long id) {
      SystemExtendDictItem upsystemExtendDictItem = systemExtendDictItemServiceImpl.getById(id);
      if(upsystemExtendDictItem != null){
        upsystemExtendDictItem = ObjectCopyUtils.copyProperties(systemExtendDictItem,upsystemExtendDictItem,true);
      }
      return XfR.ok(systemExtendDictItemServiceImpl.updateById(upsystemExtendDictItem));
  }

  /**
   * 通过id删除系统枚举扩展明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemextenddictitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemExtendDictItemServiceImpl.removeById(id));
  }

  @PostMapping("/systemextenddictitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_extend_dict_item");
     params.put("request", condition);

     return XfR.ok(systemExtendDictItemServiceImpl.querys(params));
  }

}
