package com.xforceplus.ultraman.app.jcnestle.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcnestle.entity.SystemExtendField;
import com.xforceplus.ultraman.app.jcnestle.service.ISystemExtendFieldService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 组织扩展字段系统对象前端控制器
 *
 * @author ultraman
 * @date 2024-12-13
 */
@RestController
public class SystemExtendFieldController {

  @Autowired
  private ISystemExtendFieldService systemExtendFieldServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemExtendField 组织扩展字段系统对象
   * @return
   */
  @GetMapping("/systemextendfields" )
  public XfR getSystemExtendFields(XfPage page, SystemExtendField systemExtendField) {
    return XfR.ok(systemExtendFieldServiceImpl.page(page, Wrappers.query(systemExtendField)));
  }

  /**
   * 通过id查询组织扩展字段系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemextendfields/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemExtendFieldServiceImpl.getById(id));
  }

  /**
   * 新增组织扩展字段系统对象
   * @param systemExtendField 组织扩展字段系统对象
   * @return XfR
   */
  @PostMapping("/systemextendfields")
  public XfR save(@RequestBody SystemExtendField systemExtendField) {
     return XfR.ok(systemExtendFieldServiceImpl.save(systemExtendField));
  }

  /**
   * 修改-传入修改后的全部数据组织扩展字段系统对象
   * @param systemExtendField 组织扩展字段系统对象
   * @return XfR
   */
  @PutMapping("/systemextendfields/{id}")
  public XfR putUpdate(@RequestBody SystemExtendField systemExtendField,@PathVariable Long id) {
      systemExtendField.setId(id);
      return XfR.ok(systemExtendFieldServiceImpl.updateById(systemExtendField));
  }

  /**
   * 修改-传入修改的数据组织扩展字段系统对象
   * @param systemExtendField 组织扩展字段系统对象
   * @return XfR
   */
  @PatchMapping("/systemextendfields/{id}")
  public XfR patchUpdate(@RequestBody SystemExtendField systemExtendField,@PathVariable Long id) {
      SystemExtendField upsystemExtendField = systemExtendFieldServiceImpl.getById(id);
      if(upsystemExtendField != null){
        upsystemExtendField = ObjectCopyUtils.copyProperties(systemExtendField,upsystemExtendField,true);
      }
      return XfR.ok(systemExtendFieldServiceImpl.updateById(upsystemExtendField));
  }

  /**
   * 通过id删除组织扩展字段系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemextendfields/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemExtendFieldServiceImpl.removeById(id));
  }

  @PostMapping("/systemextendfields/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_extend_field");
     params.put("request", condition);

     return XfR.ok(systemExtendFieldServiceImpl.querys(params));
  }

}
