package com.xforceplus.ultraman.app.jcnestle.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcnestle.entity.SystemOrg;
import com.xforceplus.ultraman.app.jcnestle.service.ISystemOrgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 组织系统对象前端控制器
 *
 * @author ultraman
 * @date 2024-12-13
 */
@RestController
public class SystemOrgController {

  @Autowired
  private ISystemOrgService systemOrgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemOrg 组织系统对象
   * @return
   */
  @GetMapping("/systemorgs" )
  public XfR getSystemOrgs(XfPage page, SystemOrg systemOrg) {
    return XfR.ok(systemOrgServiceImpl.page(page, Wrappers.query(systemOrg)));
  }

  /**
   * 通过id查询组织系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemorgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemOrgServiceImpl.getById(id));
  }

  /**
   * 新增组织系统对象
   * @param systemOrg 组织系统对象
   * @return XfR
   */
  @PostMapping("/systemorgs")
  public XfR save(@RequestBody SystemOrg systemOrg) {
     return XfR.ok(systemOrgServiceImpl.save(systemOrg));
  }

  /**
   * 修改-传入修改后的全部数据组织系统对象
   * @param systemOrg 组织系统对象
   * @return XfR
   */
  @PutMapping("/systemorgs/{id}")
  public XfR putUpdate(@RequestBody SystemOrg systemOrg,@PathVariable Long id) {
      systemOrg.setId(id);
      return XfR.ok(systemOrgServiceImpl.updateById(systemOrg));
  }

  /**
   * 修改-传入修改的数据组织系统对象
   * @param systemOrg 组织系统对象
   * @return XfR
   */
  @PatchMapping("/systemorgs/{id}")
  public XfR patchUpdate(@RequestBody SystemOrg systemOrg,@PathVariable Long id) {
      SystemOrg upsystemOrg = systemOrgServiceImpl.getById(id);
      if(upsystemOrg != null){
        upsystemOrg = ObjectCopyUtils.copyProperties(systemOrg,upsystemOrg,true);
      }
      return XfR.ok(systemOrgServiceImpl.updateById(upsystemOrg));
  }

  /**
   * 通过id删除组织系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemorgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemOrgServiceImpl.removeById(id));
  }

  @PostMapping("/systemorgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_org");
     params.put("request", condition);

     return XfR.ok(systemOrgServiceImpl.querys(params));
  }

}
