package com.xforceplus.ultraman.app.jcnestle.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcnestle.entity.UploadFailureDetails;
import com.xforceplus.ultraman.app.jcnestle.service.IUploadFailureDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务单上传失败详情前端控制器
 *
 * @author ultraman
 * @date 2024-12-04
 */
@RestController
public class UploadFailureDetailsController {

  @Autowired
  private IUploadFailureDetailsService uploadFailureDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param uploadFailureDetails 业务单上传失败详情
   * @return
   */
  @GetMapping("/uploadfailuredetailss" )
  public XfR getUploadFailureDetailss(XfPage page, UploadFailureDetails uploadFailureDetails) {
    return XfR.ok(uploadFailureDetailsServiceImpl.page(page, Wrappers.query(uploadFailureDetails)));
  }

  /**
   * 通过id查询业务单上传失败详情
   * @param  id
   * @return XfR
   */
  @GetMapping("/uploadfailuredetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(uploadFailureDetailsServiceImpl.getById(id));
  }

  /**
   * 新增业务单上传失败详情
   * @param uploadFailureDetails 业务单上传失败详情
   * @return XfR
   */
  @PostMapping("/uploadfailuredetailss")
  public XfR save(@RequestBody UploadFailureDetails uploadFailureDetails) {
     return XfR.ok(uploadFailureDetailsServiceImpl.save(uploadFailureDetails));
  }

  /**
   * 修改-传入修改后的全部数据业务单上传失败详情
   * @param uploadFailureDetails 业务单上传失败详情
   * @return XfR
   */
  @PutMapping("/uploadfailuredetailss/{id}")
  public XfR putUpdate(@RequestBody UploadFailureDetails uploadFailureDetails,@PathVariable Long id) {
      uploadFailureDetails.setId(id);
      return XfR.ok(uploadFailureDetailsServiceImpl.updateById(uploadFailureDetails));
  }

  /**
   * 修改-传入修改的数据业务单上传失败详情
   * @param uploadFailureDetails 业务单上传失败详情
   * @return XfR
   */
  @PatchMapping("/uploadfailuredetailss/{id}")
  public XfR patchUpdate(@RequestBody UploadFailureDetails uploadFailureDetails,@PathVariable Long id) {
      UploadFailureDetails upuploadFailureDetails = uploadFailureDetailsServiceImpl.getById(id);
      if(upuploadFailureDetails != null){
        upuploadFailureDetails = ObjectCopyUtils.copyProperties(uploadFailureDetails,upuploadFailureDetails,true);
      }
      return XfR.ok(uploadFailureDetailsServiceImpl.updateById(upuploadFailureDetails));
  }

  /**
   * 通过id删除业务单上传失败详情
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/uploadfailuredetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(uploadFailureDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/uploadfailuredetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "upload_failure_details");
     params.put("request", condition);

     return XfR.ok(uploadFailureDetailsServiceImpl.querys(params));
  }

}
