package com.xforceplus.ultraman.app.jcpolybuild.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 接口业务类型
 * </p>
 *
 * @author ultraman
 * @since 2021-09-14
 */
public enum ApiBizType {

    _1("1", "业务单上传平台"),
    _2("2", "业务单上传反馈属地"),
    _3("3", "销项开票下发属地"),
    _4("4", "进项发票下发属地"),
    _5("5", "销项开票推送PM"),
    _6("6", "进项发票推送PM"),
    _7("7", "申请红字信息表"),
    _8("8", "同步红字信息表申请状态"),
    _9("9", "撤销红字信息表"),
    _10("10", "同步红字信息表撤销状态"),
    _11("11", "业务单上传反馈推送PM"),
    _12("12", "供应商协同标识下发属地"),
    _13("13", "供应商协同标识推送PM"),
    _14("14", "删除PM系统发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApiBizType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApiBizType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            default:
                return null;
        }
    }
}
