package com.xforceplus.ultraman.app.jcpolybuild.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红字信息申请表状态
 * </p>
 *
 * @author ultraman
 * @since 2021-09-14
 */
public enum ApplyLetterStatus {

    _1("1", "待申请"),
    _2("2", "申请中"),
    _3("3", "已通过"),
    _4("4", "不通过"),
    _5("5", "已核销"),
    _6("6", "申请失败"),
    _7("7", "撤回中"),
    _8("8", "已撤销"),
    _9("9", "撤回失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplyLetterStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyLetterStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
