package com.xforceplus.ultraman.app.jcpolybuild.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红字信息表状态
 * </p>
 *
 * @author ultraman
 * @since 2021-09-14
 */
public enum LetterStatus {

    _1("1", "审核通过"),
    _2("2", "审核不通过"),
    _3("3", "已核销"),
    _4("4", "已撤销"),
    _0("0", "申请中");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LetterStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LetterStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
