package com.xforceplus.ultraman.app.jcpolybuild.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcpolybuild.entity.InvoiceExt;
import com.xforceplus.ultraman.app.jcpolybuild.service.IInvoiceExtService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票信息扩展信息前端控制器
 *
 * @author ultraman
 * @date 2023-11-08
 */
@RestController
public class InvoiceExtController {

  @Autowired
  private IInvoiceExtService invoiceExtServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceExt 发票信息扩展信息
   * @return
   */
  @GetMapping("/invoiceexts" )
  public XfR getInvoiceExts(XfPage page, InvoiceExt invoiceExt) {
    return XfR.ok(invoiceExtServiceImpl.page(page, Wrappers.query(invoiceExt)));
  }

  /**
   * 通过id查询发票信息扩展信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceexts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceExtServiceImpl.getById(id));
  }

  /**
   * 新增发票信息扩展信息
   * @param invoiceExt 发票信息扩展信息
   * @return XfR
   */
  @PostMapping("/invoiceexts")
  public XfR save(@RequestBody InvoiceExt invoiceExt) {
     return XfR.ok(invoiceExtServiceImpl.save(invoiceExt));
  }

  /**
   * 修改-传入修改后的全部数据发票信息扩展信息
   * @param invoiceExt 发票信息扩展信息
   * @return XfR
   */
  @PutMapping("/invoiceexts/{id}")
  public XfR putUpdate(@RequestBody InvoiceExt invoiceExt,@PathVariable Long id) {
      invoiceExt.setId(id);
      return XfR.ok(invoiceExtServiceImpl.updateById(invoiceExt));
  }

  /**
   * 修改-传入修改的数据发票信息扩展信息
   * @param invoiceExt 发票信息扩展信息
   * @return XfR
   */
  @PatchMapping("/invoiceexts/{id}")
  public XfR patchUpdate(@RequestBody InvoiceExt invoiceExt,@PathVariable Long id) {
      InvoiceExt upinvoiceExt = invoiceExtServiceImpl.getById(id);
      if(upinvoiceExt != null){
        upinvoiceExt = ObjectCopyUtils.copyProperties(invoiceExt,upinvoiceExt,true);
      }
      return XfR.ok(invoiceExtServiceImpl.updateById(upinvoiceExt));
  }

  /**
   * 通过id删除发票信息扩展信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceexts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceExtServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceexts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_ext");
     params.put("request", condition);

     return XfR.ok(invoiceExtServiceImpl.querys(params));
  }

}
