package com.xforceplus.ultraman.app.jcpolybuild.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcpolybuild.entity.RedDetails;
import com.xforceplus.ultraman.app.jcpolybuild.service.IRedDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 红字信息表申请明细前端控制器
 *
 * @author ultraman
 * @date 2023-11-08
 */
@RestController
public class RedDetailsController {

  @Autowired
  private IRedDetailsService redDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redDetails 红字信息表申请明细
   * @return
   */
  @GetMapping("/reddetailss" )
  public XfR getRedDetailss(XfPage page, RedDetails redDetails) {
    return XfR.ok(redDetailsServiceImpl.page(page, Wrappers.query(redDetails)));
  }

  /**
   * 通过id查询红字信息表申请明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/reddetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redDetailsServiceImpl.getById(id));
  }

  /**
   * 新增红字信息表申请明细
   * @param redDetails 红字信息表申请明细
   * @return XfR
   */
  @PostMapping("/reddetailss")
  public XfR save(@RequestBody RedDetails redDetails) {
     return XfR.ok(redDetailsServiceImpl.save(redDetails));
  }

  /**
   * 修改-传入修改后的全部数据红字信息表申请明细
   * @param redDetails 红字信息表申请明细
   * @return XfR
   */
  @PutMapping("/reddetailss/{id}")
  public XfR putUpdate(@RequestBody RedDetails redDetails,@PathVariable Long id) {
      redDetails.setId(id);
      return XfR.ok(redDetailsServiceImpl.updateById(redDetails));
  }

  /**
   * 修改-传入修改的数据红字信息表申请明细
   * @param redDetails 红字信息表申请明细
   * @return XfR
   */
  @PatchMapping("/reddetailss/{id}")
  public XfR patchUpdate(@RequestBody RedDetails redDetails,@PathVariable Long id) {
      RedDetails upredDetails = redDetailsServiceImpl.getById(id);
      if(upredDetails != null){
        upredDetails = ObjectCopyUtils.copyProperties(redDetails,upredDetails,true);
      }
      return XfR.ok(redDetailsServiceImpl.updateById(upredDetails));
  }

  /**
   * 通过id删除红字信息表申请明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reddetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/reddetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_details");
     params.put("request", condition);

     return XfR.ok(redDetailsServiceImpl.querys(params));
  }

}
