package com.xforceplus.ultraman.app.jcpolybuild.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcpolybuild.entity.TerminalInfo;
import com.xforceplus.ultraman.app.jcpolybuild.service.ITerminalInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 设备信息前端控制器
 *
 * @author ultraman
 * @date 2023-11-08
 */
@RestController
public class TerminalInfoController {

  @Autowired
  private ITerminalInfoService terminalInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param terminalInfo 设备信息
   * @return
   */
  @GetMapping("/terminalinfos" )
  public XfR getTerminalInfos(XfPage page, TerminalInfo terminalInfo) {
    return XfR.ok(terminalInfoServiceImpl.page(page, Wrappers.query(terminalInfo)));
  }

  /**
   * 通过id查询设备信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/terminalinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(terminalInfoServiceImpl.getById(id));
  }

  /**
   * 新增设备信息
   * @param terminalInfo 设备信息
   * @return XfR
   */
  @PostMapping("/terminalinfos")
  public XfR save(@RequestBody TerminalInfo terminalInfo) {
     return XfR.ok(terminalInfoServiceImpl.save(terminalInfo));
  }

  /**
   * 修改-传入修改后的全部数据设备信息
   * @param terminalInfo 设备信息
   * @return XfR
   */
  @PutMapping("/terminalinfos/{id}")
  public XfR putUpdate(@RequestBody TerminalInfo terminalInfo,@PathVariable Long id) {
      terminalInfo.setId(id);
      return XfR.ok(terminalInfoServiceImpl.updateById(terminalInfo));
  }

  /**
   * 修改-传入修改的数据设备信息
   * @param terminalInfo 设备信息
   * @return XfR
   */
  @PatchMapping("/terminalinfos/{id}")
  public XfR patchUpdate(@RequestBody TerminalInfo terminalInfo,@PathVariable Long id) {
      TerminalInfo upterminalInfo = terminalInfoServiceImpl.getById(id);
      if(upterminalInfo != null){
        upterminalInfo = ObjectCopyUtils.copyProperties(terminalInfo,upterminalInfo,true);
      }
      return XfR.ok(terminalInfoServiceImpl.updateById(upterminalInfo));
  }

  /**
   * 通过id删除设备信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/terminalinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(terminalInfoServiceImpl.removeById(id));
  }

  @PostMapping("/terminalinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "terminal_info");
     params.put("request", condition);

     return XfR.ok(terminalInfoServiceImpl.querys(params));
  }

}
