package com.xforceplus.ultraman.app.jcprojectmanager.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcprojectmanager.entity.BusinessBody;
import com.xforceplus.ultraman.app.jcprojectmanager.service.IBusinessBodyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-14
 */
@RestController
public class BusinessBodyController {

  @Autowired
  private IBusinessBodyService businessBodyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessBody ${table.comment}
   * @return
   */
  @GetMapping("/businessbodys" )
  public XfR getBusinessBodys(XfPage page, BusinessBody businessBody) {
    return XfR.ok(businessBodyServiceImpl.page(page, Wrappers.query(businessBody)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessbodys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessBodyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param businessBody ${table.comment}
   * @return XfR
   */
  @PostMapping("/businessbodys")
  public XfR save(@RequestBody BusinessBody businessBody) {
     return XfR.ok(businessBodyServiceImpl.save(businessBody));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param businessBody ${table.comment}
   * @return XfR
   */
  @PutMapping("/businessbodys/{id}")
  public XfR putUpdate(@RequestBody BusinessBody businessBody,@PathVariable Long id) {
      businessBody.setId(id);
      return XfR.ok(businessBodyServiceImpl.updateById(businessBody));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param businessBody ${table.comment}
   * @return XfR
   */
  @PatchMapping("/businessbodys/{id}")
  public XfR patchUpdate(@RequestBody BusinessBody businessBody,@PathVariable Long id) {
      BusinessBody upbusinessBody = businessBodyServiceImpl.getById(id);
      if(upbusinessBody != null){
        upbusinessBody = ObjectCopyUtils.copyProperties(businessBody,upbusinessBody,true);
      }
      return XfR.ok(businessBodyServiceImpl.updateById(upbusinessBody));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessbodys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessBodyServiceImpl.removeById(id));
  }

  @PostMapping("/businessbodys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_body");
     params.put("request", condition);

     return XfR.ok(businessBodyServiceImpl.querys(params));
  }

}
