package com.xforceplus.ultraman.app.jcprojectmanager.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcprojectmanager.entity.BusinessData;
import com.xforceplus.ultraman.app.jcprojectmanager.service.IBusinessDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-14
 */
@RestController
public class BusinessDataController {

  @Autowired
  private IBusinessDataService businessDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessData ${table.comment}
   * @return
   */
  @GetMapping("/businessdatas" )
  public XfR getBusinessDatas(XfPage page, BusinessData businessData) {
    return XfR.ok(businessDataServiceImpl.page(page, Wrappers.query(businessData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param businessData ${table.comment}
   * @return XfR
   */
  @PostMapping("/businessdatas")
  public XfR save(@RequestBody BusinessData businessData) {
     return XfR.ok(businessDataServiceImpl.save(businessData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param businessData ${table.comment}
   * @return XfR
   */
  @PutMapping("/businessdatas/{id}")
  public XfR putUpdate(@RequestBody BusinessData businessData,@PathVariable Long id) {
      businessData.setId(id);
      return XfR.ok(businessDataServiceImpl.updateById(businessData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param businessData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/businessdatas/{id}")
  public XfR patchUpdate(@RequestBody BusinessData businessData,@PathVariable Long id) {
      BusinessData upbusinessData = businessDataServiceImpl.getById(id);
      if(upbusinessData != null){
        upbusinessData = ObjectCopyUtils.copyProperties(businessData,upbusinessData,true);
      }
      return XfR.ok(businessDataServiceImpl.updateById(upbusinessData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessDataServiceImpl.removeById(id));
  }

  @PostMapping("/businessdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_data");
     params.put("request", condition);

     return XfR.ok(businessDataServiceImpl.querys(params));
  }

}
