package com.xforceplus.ultraman.app.jcprojectmanager.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcprojectmanager.entity.ProjectStage;
import com.xforceplus.ultraman.app.jcprojectmanager.service.IProjectStageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-14
 */
@RestController
public class ProjectStageController {

  @Autowired
  private IProjectStageService projectStageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param projectStage ${table.comment}
   * @return
   */
  @GetMapping("/projectstages" )
  public XfR getProjectStages(XfPage page, ProjectStage projectStage) {
    return XfR.ok(projectStageServiceImpl.page(page, Wrappers.query(projectStage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/projectstages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(projectStageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param projectStage ${table.comment}
   * @return XfR
   */
  @PostMapping("/projectstages")
  public XfR save(@RequestBody ProjectStage projectStage) {
     return XfR.ok(projectStageServiceImpl.save(projectStage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param projectStage ${table.comment}
   * @return XfR
   */
  @PutMapping("/projectstages/{id}")
  public XfR putUpdate(@RequestBody ProjectStage projectStage,@PathVariable Long id) {
      projectStage.setId(id);
      return XfR.ok(projectStageServiceImpl.updateById(projectStage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param projectStage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/projectstages/{id}")
  public XfR patchUpdate(@RequestBody ProjectStage projectStage,@PathVariable Long id) {
      ProjectStage upprojectStage = projectStageServiceImpl.getById(id);
      if(upprojectStage != null){
        upprojectStage = ObjectCopyUtils.copyProperties(projectStage,upprojectStage,true);
      }
      return XfR.ok(projectStageServiceImpl.updateById(upprojectStage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/projectstages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(projectStageServiceImpl.removeById(id));
  }

  @PostMapping("/projectstages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "project_stage");
     params.put("request", condition);

     return XfR.ok(projectStageServiceImpl.querys(params));
  }

}
