package com.xforceplus.ultraman.app.jcprojectmanager.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcprojectmanager.entity.StagePerformance;
import com.xforceplus.ultraman.app.jcprojectmanager.service.IStagePerformanceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-14
 */
@RestController
public class StagePerformanceController {

  @Autowired
  private IStagePerformanceService stagePerformanceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param stagePerformance ${table.comment}
   * @return
   */
  @GetMapping("/stageperformances" )
  public XfR getStagePerformances(XfPage page, StagePerformance stagePerformance) {
    return XfR.ok(stagePerformanceServiceImpl.page(page, Wrappers.query(stagePerformance)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/stageperformances/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(stagePerformanceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param stagePerformance ${table.comment}
   * @return XfR
   */
  @PostMapping("/stageperformances")
  public XfR save(@RequestBody StagePerformance stagePerformance) {
     return XfR.ok(stagePerformanceServiceImpl.save(stagePerformance));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param stagePerformance ${table.comment}
   * @return XfR
   */
  @PutMapping("/stageperformances/{id}")
  public XfR putUpdate(@RequestBody StagePerformance stagePerformance,@PathVariable Long id) {
      stagePerformance.setId(id);
      return XfR.ok(stagePerformanceServiceImpl.updateById(stagePerformance));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param stagePerformance ${table.comment}
   * @return XfR
   */
  @PatchMapping("/stageperformances/{id}")
  public XfR patchUpdate(@RequestBody StagePerformance stagePerformance,@PathVariable Long id) {
      StagePerformance upstagePerformance = stagePerformanceServiceImpl.getById(id);
      if(upstagePerformance != null){
        upstagePerformance = ObjectCopyUtils.copyProperties(stagePerformance,upstagePerformance,true);
      }
      return XfR.ok(stagePerformanceServiceImpl.updateById(upstagePerformance));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/stageperformances/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(stagePerformanceServiceImpl.removeById(id));
  }

  @PostMapping("/stageperformances/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "stage_performance");
     params.put("request", condition);

     return XfR.ok(stagePerformanceServiceImpl.querys(params));
  }

}
