package com.xforceplus.ultraman.app.jcprojectmanager.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcprojectmanager.entity.TaskData;
import com.xforceplus.ultraman.app.jcprojectmanager.service.ITaskDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-14
 */
@RestController
public class TaskDataController {

  @Autowired
  private ITaskDataService taskDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taskData ${table.comment}
   * @return
   */
  @GetMapping("/taskdatas" )
  public XfR getTaskDatas(XfPage page, TaskData taskData) {
    return XfR.ok(taskDataServiceImpl.page(page, Wrappers.query(taskData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taskdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taskDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taskData ${table.comment}
   * @return XfR
   */
  @PostMapping("/taskdatas")
  public XfR save(@RequestBody TaskData taskData) {
     return XfR.ok(taskDataServiceImpl.save(taskData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taskData ${table.comment}
   * @return XfR
   */
  @PutMapping("/taskdatas/{id}")
  public XfR putUpdate(@RequestBody TaskData taskData,@PathVariable Long id) {
      taskData.setId(id);
      return XfR.ok(taskDataServiceImpl.updateById(taskData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taskData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taskdatas/{id}")
  public XfR patchUpdate(@RequestBody TaskData taskData,@PathVariable Long id) {
      TaskData uptaskData = taskDataServiceImpl.getById(id);
      if(uptaskData != null){
        uptaskData = ObjectCopyUtils.copyProperties(taskData,uptaskData,true);
      }
      return XfR.ok(taskDataServiceImpl.updateById(uptaskData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taskdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taskDataServiceImpl.removeById(id));
  }

  @PostMapping("/taskdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "task_data");
     params.put("request", condition);

     return XfR.ok(taskDataServiceImpl.querys(params));
  }

}
