package com.xforceplus.ultraman.app.jcprojectmanager.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcprojectmanager.entity.WorkData;
import com.xforceplus.ultraman.app.jcprojectmanager.service.IWorkDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-14
 */
@RestController
public class WorkDataController {

  @Autowired
  private IWorkDataService workDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param workData ${table.comment}
   * @return
   */
  @GetMapping("/workdatas" )
  public XfR getWorkDatas(XfPage page, WorkData workData) {
    return XfR.ok(workDataServiceImpl.page(page, Wrappers.query(workData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/workdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(workDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param workData ${table.comment}
   * @return XfR
   */
  @PostMapping("/workdatas")
  public XfR save(@RequestBody WorkData workData) {
     return XfR.ok(workDataServiceImpl.save(workData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param workData ${table.comment}
   * @return XfR
   */
  @PutMapping("/workdatas/{id}")
  public XfR putUpdate(@RequestBody WorkData workData,@PathVariable Long id) {
      workData.setId(id);
      return XfR.ok(workDataServiceImpl.updateById(workData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param workData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/workdatas/{id}")
  public XfR patchUpdate(@RequestBody WorkData workData,@PathVariable Long id) {
      WorkData upworkData = workDataServiceImpl.getById(id);
      if(upworkData != null){
        upworkData = ObjectCopyUtils.copyProperties(workData,upworkData,true);
      }
      return XfR.ok(workDataServiceImpl.updateById(upworkData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/workdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(workDataServiceImpl.removeById(id));
  }

  @PostMapping("/workdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "work_data");
     params.put("request", condition);

     return XfR.ok(workDataServiceImpl.querys(params));
  }

}
