package com.xforceplus.ultraman.app.jcprojectoperation.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * export_enterprises_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-18
 */
public enum ExportEnterprisesType {

    _01("01", "一类出口企业"),
    _02("02", "二类出口企业"),
    _03("03", "三类出口企业"),
    _04("04", "四类出口企业");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExportEnterprisesType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExportEnterprisesType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            default:
                return null;
        }
    }
}
